capture log close
clear all
macro drop _all
cd "C:\Users\alice\Quantonomics Dropbox\Quantonomics Team Folder\AER25\1. Opex Function Development\xtreg"
set more off
set maxiter 300

**** SET PERIOD ***
local perd "short"      // can be "long" or "short"

log using Outputs/log/anOpexReg24-xtreg-`perd', replace text

display "Models: `perd'"

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function Development
Author:  Alice Giovani
File:    anOpexReg24_xtreg.do
Initial Date:   13May2025
Revised Date:	 6Jun2025

--------------------------------------------------------------------------*/
tempfile data data1

* Period & dependent variable

if "`perd'" == "long" {
	local startyr 2006
	}
else if "`perd'" == "short" {
	local startyr 2012
}
local endyr   2023

* 

scalar define ppp_aust   		   = 1.527404363
scalar define ppp_nz    		   = 1.482877481
scalar define ppp_canada		   = 1.249076963

scalar define propex_rebase_aust   = 1.238501756
scalar define propex_rebase_nz     = 1.219668445
scalar define propex_rebase_canada = 1.160126855  

* Read data

use Input/DNSPopex24.dta, clear
xtset eiid year

gen int dnsp = eiid - 1000 if country == 1
qui tabulate dnsp, gen(d)
forvalues k = 1/13 {
	replace d`k' = 0 if d`k' == .
}

tabulate country, gen(jur)
correlate custnum circlen rmdem shareugc
tabulate year

summarize d* jur*

* Sample selection
*-------------------------

drop if country == 3 & year < (`startyr' - 1)
drop if country < 3 & year < `startyr'
drop if country == 3 & year > (`endyr' - 1)
drop if country < 3 & year > `endyr'

* Modify & create variables
*--------------------------

* Adressing change of VIC's DNSP from calendar to financial year in 2021

generate yr=year
replace yr=yr+0.5 if dnsp==3 & year<2021
replace yr=yr+0.5 if dnsp==8 & year<2021
replace yr=yr+0.5 if dnsp==9 & year<2021
replace yr=yr+0.5 if dnsp==11 & year<2021
replace yr=yr+0.5 if dnsp==13 & year<2021
replace yr=yr-0.25 if country==2
replace yr=yr+0.5 if country==3

replace propex = propex / propex_rebase_aust    if country==1
replace propex = propex / propex_rebase_nz      if country==2
replace propex = propex / propex_rebase_canada  if country==3
replace propex = propex * ppp_nz / ppp_aust     if country==2
replace propex = propex * ppp_canada / ppp_aust if country==3

*gen lastob = 0
*replace lastob = 1 if dnsp != dnsp[_n+1]

* Regression log variables

gen lvc = log(opex / propex)
gen ly1 = log(custnum)
gen ly2 = log(circlen)
gen ly3 = log(rmdem)
gen lz1 = log(shareugc)

* mean correct output data

qui reg ly1
predict mly1
replace ly1=ly1-mly1
qui reg ly2
predict mly2
replace ly2=ly2-mly2
qui reg ly3
predict mly3
replace ly3=ly3-mly3

* TLG variables

gen ly11 = (ly1^2)/2
gen ly12 = ly1*ly2
gen ly13 = ly1*ly3
gen ly22 = (ly2^2)/2
gen ly23 = ly2*ly3
gen ly33 = (ly3^2)/2

* Labels

label variable ly1  "ln(Custnum)=x1" 
label variable ly2  "ln(CircLen)=x2" 
label variable ly3  "ln(RMDemand)=x3" 
label variable lz1  "ln(ShareUGC)" 
label variable ly11 "x1*x1/2" 
label variable ly12 "x1*x2" 
label variable ly13 "x1*x3" 
label variable ly22 "x2*x2/2" 
label variable ly23 "x2*x3" 
label variable ly33 "x3*x3/2"
label variable yr   "Year" 
label variable jur2 "New Zealand" 
label variable jur3 "Ontario" 
label variable d2   "AGD" 
label variable d3   "CIT" 
label variable d4   "END" 
label variable d5   "ENX" 
label variable d6   "ERG"
label variable d7   "ESS" 
label variable d8   "JEN" 
label variable d9   "PCR" 
label variable d10  "SAP"
label variable d11  "AND" 
label variable d12  "TND" 
label variable d13  "UED"

* Regression models
*---------------------- 

*================================
* 1. LSECD
*================================

xtreg lvc ly1 ly2 ly3 lz1 yr, fe 
estimates store LSECD

predict ci, u
quietly summarize ci

*Efficiency
gen ineff = r(max) - ci /* Predict inefficiency */
gen eff = exp(-ineff) /* Predict efficiency */

table dnsp, statistic(mean eff)
table country, statistic(mean eff)


* Output elasticities	

predictnl ely1 = (_b[ly1]), ci(lw_y1 up_y1)
predictnl ely2 = (_b[ly2]), ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3]), ci(lw_y3 up_y3)
predictnl elY  = (_b[ly1] + _b[ly2] + _b[ly3]), ci(lw_Y up_Y)

* Tabulation

table (country) (var), stat(mean eff)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD", replace)

table (dnsp) (var) if eiid < 2000, stat(mean eff)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A8)

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A39)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A46)	
	
	
* STATS TESTS
predict yhat, xb
gen eh = lvc - yhat
estat ic

scalar k_sfacd = 6		
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_sfacd))	
display "SFACD Pseudo-adjusted R2 = " `psadjr2'

iqr eh
swilk eh
collin ly1 ly2 ly3 lz1 yr

	
drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 elY lw_Y up_Y ///
	eff ci ineff yhat eh


*================================
* 2. LSETLG
*================================

xtreg lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr, fe 
predict fe_effects_tlg, u

estimates store LSETLG

*Efficiency
predict ci, u
quietly summarize ci

gen ineff = r(max) - ci /* Predict inefficiency */
gen eff = exp(-ineff) /* Predict efficiency */

table dnsp, statistic(mean eff)
table country, statistic(mean eff)

* Output elasticities	
	
predictnl ely1 = (_b[ly1] + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3), ///
	ci(lw_y1 up_y1) p(p1)
predictnl ely2 = (_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3), ///
	ci(lw_y2 up_y2) p(p2)
predictnl ely3 = (_b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ///
	ci(lw_y3 up_y3) p(p3)
predictnl elY  = (_b[ly1]  + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 + ///
	_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 + _b[ly3] + ///
	_b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ci(lw_Y up_Y)

* Tabulation

table (country) (var), stat(mean eff)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG", replace)

table (dnsp) (var) if eiid < 2000, stat(mean eff)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A8)

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A39)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A46)

table (dnsp) (var), stat(mean ely1 lw_y1 up_y1)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A53)
	
table (dnsp) (var), stat(mean ely2 lw_y2 up_y2)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A70)
	
table (dnsp) (var), stat(mean ely3 lw_y3 up_y3)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A87)
	
	
display "MONOTONICITY VIOLATIONS"
gen mon1 = 0
gen mon2 = 0
gen mon3 = 0
gen montot = 0
replace mon1 = cond(ely1 < 0,1,0)	
replace mon2 = cond(ely2 < 0,1,0)	
replace mon3 = cond(ely3 < 0,1,0)
replace montot = 1 if mon1 == 1 | mon2 == 1 | mon3 == 1

tabstat mon1 mon2 mon3 montot, by(country) statistics(mean)
tabstat mon1 mon2 mon3 montot if dnsp <= 13, by(dnsp) statistics(mean) 


* STATS TESTS
predict yhat, xb
gen eh = lvc - yhat
estat ic

test ly11 ly12 ly13 ly22 ly23 ly33

scalar k_sfatlg = 12		
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_sfatlg))	
display "SFATLG Pseudo-adjusted R2 = " `psadjr2'

iqr eh
swilk eh
collin ly1 ly2 ly3 lz1 ly11 ly12 ly13 ly22 ly23 ly33 yr



* exporting elasticity data to excel 

export excel eiid year country custnum rmdem circlen ely1 ely2 ely3 ///
	using Outputs/xlsx/monotonicity-`perd'.xlsx, ///
	sheet("lsetlg", replace) firstrow(var) 	

drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 elY lw_Y up_Y ///
	eff mon1 mon2 mon3 montot 


* Tabulating models
*--------------------

estout LSECD using Outputs/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("LSECD-`perd'") stats(r2 N, fmt(3)) replace
estout LSETLG using Outputs/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("LSETLG-`perd'") stats(r2 N, fmt(3)) append

drop _est_LSECD	_est_LSETLG	
	
export excel using Outputs/xlsx/outputdata-`perd'.xlsx ///
	if eiid < 2000, firstrow(var) replace


*/
log close
exit
